
-------------------------------------------------------------------------------
-- Class system
-------------------------------------------------------------------------------
Class = function( prototype )
	local derived = {}
	local derivedMT = {
		--When indexing into a derived class, check the base class as well
		__index = prototype,
		
		--When invoking a class, return an instance
		__call = function( proto, ... )
			local instance = {}
			local instanceMT = {
				--When indexing into an instance, check the class hierarchy as well.
				__index = derived,
				--Calling instances is a no-no!
				__call = function() 
					print( "WARNING! Attempt to invoke an instance of a class!" )
					print( debug.traceback() )
					return instance
				end,				
			}
			setmetatable( instance, instanceMT )
			
			if ( instance.__constructor ) then
				instance:__constructor( ... )
			end
			
			return instance
		end,
	}
	setmetatable( derived, derivedMT )
	return derived	
end

-------------------------------------------------------------------------------
-- Event manager singleton.
-------------------------------------------------------------------------------
EventManager = Class()
function EventManager:__constructor( )
	NewEventManager( self )
	
	self.Events = {}
	self.PendingSubscribe = {}
	self.PendingUnsubscribe = {}
end
function EventManager:FireEvent( eventName, ... )
	self.Events[ eventName ] = self.Events[ eventName ] or {}
	
	for subscriber,_ in pairs( self.Events[ eventName ] ) do
		subscriber[ eventName ]( subscriber, ... )
	end
end
function EventManager:Update( )
	for eventName, subscriberList in pairs( self.PendingSubscribe ) do
		for subscriber,_ in pairs( subscriberList ) do
			self:Subscribe( subscriber, eventName, true )
		end
	end
	self.PendingSubscribe = {}
	
	for eventName, unsubscriberList in pairs( self.PendingUnsubscribe ) do
		for unsubscriber,_ in pairs( unsubscriberList ) do
			self:Unsubscribe( unsubscriber, eventName, true )
		end
	end
	self.PendingUnsubscribe = {}
end
function EventManager:Subscribe( subscriber, eventName, bUpdating )
	if ( bUpdating ) then
		self.Events[ eventName ] = self.Events[ eventName ] or {}
		self.Events[ eventName ][ subscriber ] = true
	else
		self.PendingSubscribe[ eventName ] = self.PendingSubscribe[ eventName ] or {}
		self.PendingSubscribe[ eventName ][ subscriber ] = true
	end
end
function EventManager:Unsubscribe( unsubscriber, eventName, bUpdating )
	if ( bUpdating ) then
		self.Events[ eventName ] = self.Events[ eventName ] or {}
		self.Events[ eventName ][ unsubscriber ] = nil
	else
		self.PendingUnsubscribe[ eventName ] = self.PendingUnsubscribe[ eventName ] or {}
		self.PendingUnsubscribe[ eventName ][ unsubscriber ] = nil
	end
end

EM = EventManager()

-------------------------------------------------------------------------------
-- Actor classes and instances
-------------------------------------------------------------------------------
Actor = Class()
function Actor:__constructor( name )
	NewLuaObject( self )
	EM:Subscribe( self, "OnUpdateScriptObjects" )
	
	self.name = name
end
function Actor:OnUpdateScriptObjects()
	print( self.name .. " got OnUpdateScriptObjects!")
end

local actor1 = Actor( "Robert" );
local actor2 = Actor( "Julie" );

Player = Class( Actor )
function Player:__constructor( name )
	NewLuaObject( self )
	EM:Subscribe( self, "OnUpdateScriptObjects" )
	
	EM:Subscribe( self, "OnArrowKeyLeft" )
	EM:Subscribe( self, "OnArrowKeyRight" )
	EM:Subscribe( self, "OnArrowKeyUp" )
	EM:Subscribe( self, "OnArrowKeyDown" )
	
	self.name = name
end
function Player:OnArrowKeyLeft()
	print( self.name .. " got OnArrowKeyLeft!" )
end
function Player:OnArrowKeyRight()
	print( self.name .. " got OnArrowKeyRight!" )
end
function Player:OnArrowKeyUp()
	print( self.name .. " got OnArrowKeyUp!" )
end
function Player:OnArrowKeyDown()
	print( self.name .. " got OnArrowKeyDown!" )
end

local player = Player( "Player 1" );

